#!/usr/bin/python3
import tarfile
import os
import subprocess
import sys
import constant


def create_env_variables():
    return ' '.join([
        'FAKECHROOT_ELFLOADER=' + constant.OWN_ELF_LOADER,
        'FAKECHROOT_BASE=$(pwd)',
        'LD_PRELOAD=' + constant.OWN_PRELOAD,
        'LD_LIBRARY_PATH=' + constant.OWN_LIBRARY_PATHS
    ])


def run_with_own_loader(cmd):
    cmd_with_loader = create_env_variables() + ' ' + constant.OWN_ELF_LOADER + ' ' + cmd
    return run(cmd_with_loader, constant.OWN_FILE_SYSTEM_DIR)


def run(cmd, cwd=None):
    print("Running %s\n" % cmd, file=sys.stderr)
    return subprocess.run(cmd, shell=True, executable='/bin/bash', stdout=subprocess.PIPE, cwd=cwd).stdout.decode('utf-8')


def unpack_xz():
    current_dir = os.getcwd()
    os.mkdir(constant.OWN_FILE_SYSTEM_DIR)
    os.chdir(constant.OWN_FILE_SYSTEM_DIR)
    with tarfile.open('../resources/distro_flat.xz') as f:
        f.extractall('.')
    os.chdir(current_dir)


def fix_symbolic_links():
    # Find all symlinks (-xdev = with mounts) in current directory. Iterate over all links.
    # If a link is pointing to a file inside current directory, do nothing. Otherwise, if it
    # is an absolute link that points outside current directory then replace it with a redirect.
    # Except links for /proc and /dev, they should point to the processing-pipeline image
    cmd_fix_symlinks = '''
        find $(pwd) -xdev -type l | while read linkname;
        do
            target=`readlink "$linkname"`;
            case "$target" in
                $(pwd)*) ;; # do nothing
                /*) ln -vsf "$(pwd)$target" "$linkname" ;;
            esac;
        done;
        rm -rf proc dev; ln -vsf /proc && ln -vsf /dev
        '''
    print(run(cmd_fix_symlinks, constant.OWN_FILE_SYSTEM_DIR), file=sys.stderr)

