#!/bin/bash
echo '# Paths for the specific loader library from your own filesystem must be adapted';
find / -name ld-*.so* | head -n 1 | sed -u 's/^/OWN_ELF_LOADER = \"\$\(pwd\)/' | sed -u 's/$/\"/';
echo '# Path to the required and installed fakechroot library must be adapted';
find / -name libfakechroot.so | sed -u 's/^/OWN_PRELOAD = \"\$\(pwd\)/' | sed -u 's/$/\"/';
echo '# Paths to all the necessary used library paths in your own filesystem must be adapted';
ls /etc/ld.so.conf /etc/ld.so.conf.d/* | xargs cat | grep -v -E -e '^\s*(include|#|$)|fakechroot' | sed -u 's/^/\$\(pwd\)/' | tr '\n' ':' | rev | cut -c 2- | rev | sed -u 's/^/OWN_LIBRARY_PATHS = \"/' | sed -u 's/$/\"/';
echo '';
echo '# Path to the extracted filesystem relative to the current working directory after startup';
echo 'OWN_FILE_SYSTEM_DIR = "./distro"';
