{-# LANGUAGE OverloadedStrings #-}

import Control.Applicative
import Data.Aeson as Aeson
import Data.Maybe
import Data.Text (Text)
import Data.ByteString.Lazy.UTF8 as BSL

data InputData = InputData { payload :: Value, metaData :: Value } deriving Show

instance FromJSON InputData where
    parseJSON (Object v) = do
        payload <- v .: "payload"
        metaData <- v .: "metaData"
        return (InputData { payload = payload, metaData = metaData })
    parseJSON _ = empty

instance ToJSON InputData where
    toJSON (InputData payload metaData) = object ["payload" .= payload, "metaData" .= metaData ]

main :: IO ()
main = do
    -- Read input from stdin
    input <- getLine
    -- Use library aeson to decode input and transform to type InputData
    let decodedInput = Aeson.decode (BSL.fromString input) :: Maybe InputData
    -- Extract payload
    let decodedPayload = case decodedInput of Nothing -> Nothing
                                              Just x -> return $ payload x
    -- Extract metadata
    let decodedMetaData = case decodedInput of Nothing -> Nothing
                                               Just x -> return $ metaData x
    -- Write string to stdout
    putStrLn $ "Input: " ++ input ++ " MetaData: " ++ show decodedMetaData ++ " Payload: " ++ show decodedPayload

